// Playground - noun: a place where people can play

import UIKit

var guests = ["Jon", "Kim", "Kailey", "Kara"]

guests.map {
    (name: String) -> Void in print("Witaj, \(name)")
}

guests.map {print("Witaj, \($0)")}

var messages = guests.map { name in
    print("Witaj, \(name)")
}

for message in messages {
    print(message)
}


var greetGuest = { (name:String) -> Void in
    print("Witaj, gościu o imieniu \(name)")
}

var sayGoodbye = { (name:String) -> Void in
    print("Żegnaj \(name)")
}


guests.map(greetGuest)
guests.map(sayGoodbye)
    



var greetGuest2 = { (name:String) -> Void in
    if (name.hasPrefix("K")) {
        print("\(name) to jeden z gości na liście.")
    } else {
        print("\(name) nie został zaproszony.")
    }
}

guests.map(greetGuest2)

func temperatures(calculate:(Int)->Void) {
        let numbers = [72,74,76,68,70,72,66]
        numbers.map(calculate)
}

func testFunction() {
    var total = 0
    var count = 0
    let addTemps = {
        (num: Int) -> Void in
        total += num
        count += 1
    }
    temperatures(calculate: addTemps)
    print("Razem: \(total)")
    print("Liczba: \(count)")
    print("Średnia: \(total/count)")
}

testFunction()



